// Componente Layout base com Header e Footer
const Layout = {
  template: `
        <div class="min-h-screen bg-background text-foreground">
            <!-- Header -->
            <header class="bg-card border-b border-border shadow-sm">
                <div class="max-w-[1400px] mx-auto px-4 py-4">
                    <div class="flex items-center gap-3">
                        <img src="assets/govbr.webp" alt="gov.br" class="h-10 sm:h-12 w-auto">
                    </div>
                </div>
            </header>

            <!-- Main Content Slot -->
            <main>
                <slot></slot>
            </main>

            <!-- Footer (opcional - pode ser adicionado no futuro) -->
            <footer class="main-footer">
              <div class="footer-content container max-w-[1200px]">
                  <div class="footer-section footer-govbr-logo">
                    <img src="assets/govbr.webp" alt="gov.br" class="govbr-logo-footer">
                  </div>
                  <div class="footer-section footer-links">
                    <div class="footer-column">
                        <h3>Serviços</h3>
                        <ul>
                          <li><a href="#">Buscar serviços por</a></li>
                          <li><a href="#">Serviços por público alvo</a></li>
                          <li><a href="#">Orçamento Nacional</a></li>
                          <li><a href="#">Redes de Atendimento do Governo Federal</a></li>
                          <li><a href="#">Proteção de Dados Pessoais</a></li>
                          <li><a href="#">Serviços para Imigrantes</a></li>
                          <li><a href="#">Política e Orçamento</a></li>
                          <li><a href="#">Educação e Pesquisa</a></li>
                          <li><a href="#">Educação Profissional e Tecnológica</a></li>
                          <li><a href="#">Trabalho e Emprego</a></li>
                          <li><a href="#">Serviços para Pessoas com Deficiência</a></li>
                          <li><a href="#">Combate à Discriminação Racial</a></li>
                          <li><a href="#">Política de Proteção Social</a></li>
                          <li><a href="#">Política para Mulheres</a></li>
                          <li><a href="#">Saúde Reprodutiva da Mulher</a></li>
                        </ul>
                    </div>
                    <div class="footer-column">
                        <h3>Temas em Destaque</h3>
                        <ul>
                          <li><a href="#">Serviços para o cidadão</a></li>
                          <li><a href="#">Saúde</a></li>
                          <li><a href="#">Agricultura e Pecuária</a></li>
                          <li><a href="#">Cidadania e Assistência Social</a></li>
                          <li><a href="#">Ciência e Tecnologia</a></li>
                          <li><a href="#">Comunicação</a></li>
                          <li><a href="#">Cultura e Esporte</a></li>
                          <li><a href="#">Economia e Gestão Pública</a></li>
                          <li><a href="#">Educação e Pesquisa</a></li>
                          <li><a href="#">Energia</a></li>
                          <li><a href="#">Forças Armadas e Defesa Civil</a></li>
                          <li><a href="#">Infraestrutura</a></li>
                          <li><a href="#">Justiça e Segurança</a></li>
                          <li><a href="#">Meio Ambiente</a></li>
                          <li><a href="#">Trabalho e Previdência</a></li>
                          <li><a href="#">Turismo</a></li>
                        </ul>
                    </div>
                    <div class="footer-column">
                        <h3>Notícias</h3>
                        <ul>
                          <li><a href="#">Por dentro do gov.br</a></li>
                          <li><a href="#">Canais do Executivo Federal</a></li>
                          <li><a href="#">Dados do Governo Federal</a></li>
                          <li><a href="#">Empresas e Negócios</a></li>
                          <li><a href="#">Simplifique!</a></li>
                        </ul>
                    </div>
                    <div class="footer-column">
                        <h3>Navegação</h3>
                        <ul>
                          <li><a href="#">Acessibilidade</a></li>
                          <li><a href="#">Mapa do Site</a></li>
                          <li><a href="#">Termo de Uso e Aviso de Privacidade</a></li>
                        </ul>
                    </div>
                  </div>
              </div>
              <div class="footer-bottom-bar">
                  <div class="container">
                    <p>Todo o conteúdo deste site está publicado sob a licença <a href="#">Creative Commons
                        Atribuição-</a>
                    </p>
                    <div class="govbr-info">
                        <span>AA</span>
                        <span>www.gov.br</span>
                        <i class="fas fa-sync-alt"></i>
                    </div>
                  </div>
              </div>
            </footer>
        </div>
    `
};

// Exportar o componente para uso global
window.LayoutComponent = Layout;
